document.addEventListener("DOMContentLoaded", function () {
    const navToggle = document.getElementById("navToggleBtn");
    const nav = document.querySelector("header nav");

    navToggle.addEventListener("click", () => {
        nav.classList.toggle("open");
        navToggle.classList.toggle("open");
    });

    window.addEventListener("resize", () => {
        if (window.innerWidth > 700) {
            nav.classList.remove("open");
            navToggle.classList.remove("open");
        }
    });

    // slider
    const textTrack = document.querySelector("#textSlider .slide-track");
    const imageTrack = document.querySelector("#imageSlider .slide-track");
    const prevBtn = document.getElementById("prevBtn");
    const nextBtn = document.getElementById("nextBtn");

    const totalSlides = textTrack.children.length;
    let currentSlide = 0;

    function nextSlide() {
        currentSlide = (currentSlide + 1) % totalSlides;
        updateSlides();
    }

    function prevSlide() {
        currentSlide = (currentSlide -1 + totalSlides) % totalSlides;
        updateSlides();
    }

    function updateSlides() {
        const offset = -currentSlide * 100;
        textTrack.style.transform = `translateX(${offset}%)`;
        imageTrack.style.transform = `translateX(${offset}%)`;
    }

    nextBtn.addEventListener("click", nextSlide);
    prevBtn.addEventListener("click", prevSlide);
});